(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    126350,       3345]
NotebookOptionsPosition[    109659,       3096]
NotebookOutlinePosition[    110086,       3113]
CellTagsIndexPosition[    110043,       3110]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.916306810908575*^9, 3.9163068179963284`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilGebra cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
03/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.972058329659997*^9, 3.972482896304048*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[1]:=",ExpressionUUID->"78406d83-d2c6-4034-8055-12114e7c4303"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Concepto de espacio vectorial", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.9724756263011913`*^9}},ExpressionUUID->"0784176a-7fce-4cb4-93d2-\
7079f97c3024"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  RowBox[{"V", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"R", "^", "4", " ", "con", " ", 
      RowBox[{"(", 
       RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], ")"}]}], " ", "\[CirclePlus]",
      " ", 
     RowBox[{"(", 
      RowBox[{"y1", ",", "y2", ",", "y3", ",", "y4"}], ")"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "+", "y1"}], ",", " ", 
        RowBox[{"x2", "+", "y2"}], ",", " ", 
        RowBox[{"x3", "+", "y3"}], ",", " ", 
        RowBox[{"x4", "+", "y4"}]}], ")"}], " ", "y", " ", "k", " ", "\[CircleDot]",
       " ", 
      RowBox[{"(", 
       RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4"}], ")"}]}], " ", "=", 
     " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
       "k", " ", "x1", ",", " ", "k", " ", "x2", ",", " ", "k", " ", "x3", ",",
         " ", "0"}], ")"}], ".", " ", 
      RowBox[{"\[DownQuestion]Es", " ", 
       RowBox[{"(", 
        RowBox[{"V", ",", " ", 
         RowBox[{"\[CirclePlus]", 
          RowBox[{",", " ", "\[CircleDot]"}]}]}], ")"}], " ", "un", " ", 
       "espacio", " ", "vectorial", "?"}]}]}]}]}]],ExpressionUUID->
  "b241736f-0b7a-4c7b-9754-8e1c0e65ebef"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972480464019231*^9, 
   3.97248058594228*^9},ExpressionUUID->"cc6088f1-c4a0-4654-8595-\
5b2d2b17c27e"],

Cell["\<\
No es un espacio vectorial. Falla el axioma 1 \[CircleDot] v = v. Por \
ejemplo, 1 \[CircleDot] (1,2,3,4) = (1,2,3,0) \[NotEqual] (1,2,3,4).\
\>", "Text",
 CellChangeTimes->{3.972480481737822*^9, 
  3.972480600222417*^9},ExpressionUUID->"4c022d68-c9a2-4542-a99d-\
34538039ab50"],

Cell[TextData[{
 "2. ",
 Cell[BoxData[
  RowBox[{"V", " ", "=", " ", 
   RowBox[{
    RowBox[{"M3", 
     RowBox[{"(", "R", ")"}], " ", "con", " ", "A", " ", "\[CirclePlus]", " ",
      "B"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"A", " ", "+", " ", "B", " ", "\[Minus]", " ", 
      RowBox[{"I", " ", 
       RowBox[{
       "(", "I", " ", "es", " ", "la", " ", "matriz", " ", "identidad", ")"}],
        " ", "y", " ", "k", " ", "\[CircleDot]", " ", "A"}]}], " ", "=", " ", 
     RowBox[{"k", " ", "A", " ", "\[Minus]", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "\[Minus]", "1"}], ")"}], " ", "I", ".", " ", 
       RowBox[{"\[DownQuestion]Es", " ", 
        RowBox[{"(", 
         RowBox[{"V", ",", " ", 
          RowBox[{"\[CirclePlus]", 
           RowBox[{",", " ", "\[CircleDot]"}]}]}], ")"}], " ", "un", " ", 
        "espacio", " ", "vectorial", "?"}]}]}]}]}]}]],ExpressionUUID->
  "3b23c46a-44cc-462e-ae1b-00fc9b364f85"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.972480621837672*^9},ExpressionUUID->"6f1c9b23-7657-45ef-bd5b-\
9d16258f4005"],

Cell["\<\
S\[IAcute] es un espacio vectorial. El neutro es I, el inverso de A es 2 I \
\[Minus] A, y todos los axiomas se verifican con estas operaciones \
modificadas.\
\>", "Text",
 CellChangeTimes->{
  3.972480633676408*^9},ExpressionUUID->"70c4bf74-185e-478e-90e9-\
169438afb541"],

Cell["\<\
3. V = P4(R) con suma usual (p+q)(x) = p(x) + q(x) y multiplicaci\[OAcute]n \
modificada (k \[FivePointedStar] p)(x) = k p(x) + (k\[Minus]1). \
\[DownQuestion]Es (V, +, \[FivePointedStar]) un espacio vectorial?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.972480640381549*^9},ExpressionUUID->"1c0301e4-b359-4e4e-af2c-\
6a4286c4ef2d"],

Cell["\<\
No es un espacio vectorial. Falla la distributividad respecto a vectores: k \
\[FivePointedStar] (p+q) = k (p(x) + q(x)) + (k\[Minus]1), mientras que (k \
\[FivePointedStar] p) + (k \[FivePointedStar] q) = k p(x) + (k\[Minus]1) + k \
q(x) + (k\[Minus]1) = k (p(x) + q(x)) + 2 (k\[Minus]1). Las expresiones no \
coinciden.\
\>", "Text",
 CellChangeTimes->{
  3.9724806521358213`*^9},ExpressionUUID->"70ceae64-ac8f-41ac-8282-\
3ee08c1e05ca"],

Cell[TextData[{
 "4. ",
 Cell[BoxData[
  RowBox[{"V", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"R", "^", "5", " ", "con", " ", 
      RowBox[{"(", 
       RowBox[{"x1", ",", "...", ",", "x5"}], ")"}]}], " ", "\[CirclePlus]", 
     " ", 
     RowBox[{"(", 
      RowBox[{"y1", ",", "...", ",", "y5"}], ")"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x1", "+", "y1", "+", "1"}], ",", " ", 
        RowBox[{"x2", "+", "y2"}], ",", " ", 
        RowBox[{"x3", "+", "y3"}], ",", " ", 
        RowBox[{"x4", "+", "y4"}], ",", " ", 
        RowBox[{"x5", "+", "y5"}]}], ")"}], " ", "y", " ", "k", " ", "\[CircleDot]",
       " ", 
      RowBox[{"(", 
       RowBox[{"x1", ",", "...", ",", "x5"}], ")"}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "k", " ", "x1", " ", "+", " ", "k", " ", "\[Minus]", " ", "1"}], ",", 
        " ", "k", " ", "x2", ",", " ", "k", " ", "x3", ",", " ", "k", " ", 
        "x4", ",", " ", "k", " ", "x5"}], ")"}], ".", " ", 
      RowBox[{"\[DownQuestion]Es", " ", 
       RowBox[{"(", 
        RowBox[{"V", ",", " ", 
         RowBox[{"\[CirclePlus]", 
          RowBox[{",", " ", "\[CircleDot]"}]}]}], ")"}], " ", "un", " ", 
       "espacio", " ", "vectorial", "?"}]}]}]}]}]],ExpressionUUID->
  "0b290f3c-15a3-4319-b00a-9f22a21eb29e"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.972480659956291*^9},ExpressionUUID->"d57b1efe-29e7-4771-a090-\
3317f0ca350b"],

Cell["\<\
S\[IAcute] es un espacio vectorial. El neutro es (\[Minus]1,0,0,0,0), y el \
inverso de (x1,...,x5) es (\[Minus]x1\[Minus]2, \[Minus]x2, \[Minus]x3, \
\[Minus]x4, \[Minus]x5). Todos los axiomas se cumplen.\
\>", "Text",
 CellChangeTimes->{
  3.972480672449139*^9},ExpressionUUID->"65849bfb-f651-46e9-bca2-\
76adad775a4e"],

Cell[TextData[{
 "5. ",
 Cell[BoxData[
  RowBox[{"V", " ", "=", " ", 
   RowBox[{
    RowBox[{"M4", 
     RowBox[{"(", "R", ")"}], " ", "con", " ", "A", " ", "\[CirclePlus]", " ",
      "B"}], " ", "=", " ", 
    RowBox[{
     RowBox[{"A", " ", "+", " ", "B", " ", "+", " ", 
      RowBox[{"2", " ", "I", " ", 
       RowBox[{"(", 
        RowBox[{"I", " ", "identidad", " ", "4", "\[Times]", "4"}], ")"}], " ",
        "y", " ", "k", " ", "\[CircleDot]", " ", "A"}]}], " ", "=", " ", 
     RowBox[{"k", " ", "A", " ", "+", " ", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"k", "\[Minus]", "1"}], ")"}], " ", "I", ".", " ", 
       RowBox[{"\[DownQuestion]Es", " ", 
        RowBox[{"(", 
         RowBox[{"V", ",", " ", 
          RowBox[{"\[CirclePlus]", 
           RowBox[{",", " ", "\[CircleDot]"}]}]}], ")"}], " ", "un", " ", 
        "espacio", " ", "vectorial", "?"}]}]}]}]}]}]],ExpressionUUID->
  "e50bcf99-6786-4907-9763-65ab17573233"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.972480679323226*^9},ExpressionUUID->"c4944303-c495-4464-8fd5-\
1a417e771152"],

Cell["\<\
S\[IAcute] es un espacio vectorial. El neutro es \[Minus]2 I, el inverso de A \
es \[Minus]A \[Minus] 4 I, y se verifican todos los axiomas. Por ejemplo: A \
\[CirclePlus] (\[Minus]2 I) = A; (k+m) \[CircleDot] A = (k \[CircleDot] A) \
\[CirclePlus] (m \[CircleDot] A).\
\>", "Text",
 CellChangeTimes->{
  3.972480693962572*^9},ExpressionUUID->"1112410e-eadf-4f4f-ae0b-\
1e91a3eaf440"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Concepto de subespacio vectorial", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}},ExpressionUUID->"936e6ed0-9145-4228-b084-\
b6b34af3ad0b"],

Cell["\<\
1. W = {(x, y, z, w) \[Element] \:211d^4 : 2x - 3y + z = 0 y x + y - 2w = 0} \
en \:211d^4\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972481199528934*^9},ExpressionUUID->"75fcff9a-cd4d-4c6f-9fd9-\
04da53d46524"],

Cell["\<\
S\[IAcute] es un subespacio vectorial. El conjunto contiene al vector cero \
(0,0,0,0), es cerrado bajo la suma (si dos vectores satisfacen ambas \
ecuaciones  , su suma tambi\[EAcute]n las satisface) y es cerrado bajo la \
multiplicaci\[OAcute]n por escalar.\
\>", "Text",
 CellChangeTimes->{
  3.972481210929387*^9, {3.972481291616994*^9, 
   3.972481302391172*^9}},ExpressionUUID->"2fc63711-64cc-4bb7-aeb2-\
2fa8da9d95b1"],

Cell["2. W = {p(x) \[Element] \|01d4ab\:2085(\:211d) : p\[CloseCurlyQuote](1) \
= 0} en \|01d4ab\:2085(\:211d)", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.972481231420314*^9},ExpressionUUID->"d1837576-aa54-4d7f-8cb2-\
4d8f09af509a"],

Cell["\<\
S\[IAcute] es un subespacio vectorial. El polinomio cero satisface la condici\
\[OAcute]n, y si p\[CloseCurlyQuote](1)=0 y q\[CloseCurlyQuote](1)=0 entonces \
(p+q)\[CloseCurlyQuote](1)=0 y (k p)\[CloseCurlyQuote](1)=0 para cualquier \
escalar k.\
\>", "Text",
 CellChangeTimes->{
  3.972481244739561*^9, {3.972481281389872*^9, 
   3.9724812849917393`*^9}},ExpressionUUID->"eaa41564-b65e-4d24-8dba-\
592b972bcccc"],

Cell["\<\
3. W = { {{a,b,c},{d,e,f},{g,h,i}} \[Element] M\:2083(\:211d) : a + e + i = b \
+ d } en M\:2083(\:211d)\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.972481254802689*^9},ExpressionUUID->"756e49ad-738a-4985-90d3-\
625feb8d20f0"],

Cell["\<\
S\[IAcute] es un subespacio vectorial. La matriz cero satisface la igualdad. \
La suma de matrices que cumplen la condici\[OAcute]n tambi\[EAcute]n la \
cumple, y el producto por escalar preserva la relaci\[OAcute]n lineal.\
\>", "Text",
 CellChangeTimes->{{3.972481265204501*^9, 
  3.9724812786748457`*^9}},ExpressionUUID->"19e9bb73-12f7-40e2-9e69-\
63f57a61f590"],

Cell["4. W = {(x, y, z) \[Element] \:211d\.b3 : x\.b2 + y\.b2 = z\.b2} en \
\:211d\.b3", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.9724813134132357`*^9},ExpressionUUID->"72d9ac12-94e8-47b9-922c-\
626b72ca9e08"],

Cell["\<\
No es un subespacio vectorial. No es cerrado bajo la suma: por ejemplo, \
(1,0,1) y (0,1,1) pertenecen a W, pero su suma (1,1,2) no cumple 1\.b2 + \
1\.b2 = 2\.b2.\
\>", "Text",
 CellChangeTimes->{{3.9724813235232897`*^9, 
  3.972481330006185*^9}},ExpressionUUID->"cb65ba41-0d6e-4997-a161-\
7f6fbc51761a"],

Cell["5. W = {{a,b},{c,d}} \[Element] M\:2082(\:211d) : ad - bc = 1 en \
M\:2082(\:211d)", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.9724813386547127`*^9},ExpressionUUID->"5bd125ae-2444-4079-a155-\
a4182354f5bb"],

Cell["\<\
No es un subespacio vectorial. No contiene la matriz cero (su determinante es \
  0, no 1) y no es cerrado bajo la suma ni bajo el producto por escalar.\
\>", "Text",
 CellChangeTimes->{{3.972481351439147*^9, 
  3.972481353902595*^9}},ExpressionUUID->"a5af3087-1abc-4786-9985-\
0a1b69ac2ef0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Combinaci\[OAcute]n lineal", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 
  3.972475734361013*^9}},ExpressionUUID->"3e1e591c-373e-434b-aa32-\
97214f710a73"],

Cell["\<\
1. \[DownQuestion]Es (8, 1, 10, 9) combinaci\[OAcute]n lineal de {(1, 2, -1, \
3), (2, -1, 4, 1), (3, 1, 3, 4)} en \:211d\:2074?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.9724830567782583`*^9},ExpressionUUID->"69c24e66-4bb8-48b0-a009-\
56b1eae2c27b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", 
       RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", "4", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "1", ",", "10", ",", "9"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], "\n", 
 RowBox[{"MatrixRank", "[", 
  RowBox[{"A", "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "3"}], "]"}], "]"}], "]"}], "\n", 
 RowBox[{"MatrixRank", "[", "A", "]"}]}], "Input",
 CellChangeTimes->{{3.9724830616212463`*^9, 3.9724830616227083`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"86acd821-b7af-44aa-9203-045af875e955"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      FractionBox["7", "5"], "1"},
     {"0", "1", 
      RowBox[{"-", 
       FractionBox["6", "5"]}], "1"},
     {"0", "0", "0", "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.97248306293295*^9},
 CellLabel->
  "Out[3]//MatrixForm=",ExpressionUUID->"493d79bf-9948-4287-9f4d-\
14216ad45cc3"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.9724830629337*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"46faef2e-6c20-495c-b7ce-c95385469edb"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.972483062934*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"83ed6492-4418-4221-816e-5eb982e47ab0"]
}, Open  ]],

Cell["\<\
2. \[DownQuestion]Es 3x\.b3 - 2x\.b2 + 5x - 1 combinaci\[OAcute]n lineal de \
{x\.b3 + x\.b2 - 2, 2x\.b3 - x + 1, x\.b2 + 3x - 4} en P\:2083(\:211d)?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.9724830829183083`*^9},ExpressionUUID->"a21fde74-5d82-428a-8946-\
11a2c1ca7b4d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Matriz", " ", "de", " ", 
    RowBox[{"coeficientes", ":", 
     RowBox[{"cada", " ", "fila", " ", "representa", " ", "los", " ", 
      RowBox[{"coeficientes", "[", 
       RowBox[{"x\.b3", ",", "x\.b2", ",", "x", ",", "constante"}], 
       "]"}]}]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "3", ",", 
         RowBox[{"-", "4"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "2"}], ",", "5", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], "\n", 
   RowBox[{"MatrixRank", "[", 
    RowBox[{"A", "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "3"}], "]"}], "]"}], "]"}], "\n", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.972483090383473*^9, 3.972483090385182*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"ef8729b8-4d16-4148-833f-f7deb72e668c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0"},
     {"0", "1", "0", "0"},
     {"0", "0", "1", "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.972483091648613*^9},
 CellLabel->
  "Out[7]//MatrixForm=",ExpressionUUID->"f6f6716c-c63a-49f5-94cc-\
c7619d6c900a"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972483091650202*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"6343e9d8-9bc1-4f56-b150-005d8d37d217"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.972483091650855*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"8fbf5cc0-1e73-46a6-9722-91cfcd94517b"]
}, Open  ]],

Cell["\<\
3. \[DownQuestion]Es la matriz (5 7 0; 3 3 4) combinaci\[OAcute]n lineal de \
{(1 2 0; 1 1 1), (2 -1 1; 0 2 -1), (1 4 -1; 1 -1 3)} en M\:2082\:2093\:2083(\
\:211d)?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.9724831004421988`*^9},ExpressionUUID->"c720e754-2f4d-484b-ada0-\
eef8389047f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Representamos", " ", "las", " ", "matrices", " ", "como", " ", "vectores",
     " ", "de", " ", "6", " ", "componentes"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "0", ",", "1", ",", "1", ",", "1"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "4", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", 
         RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "7", ",", "0", ",", "3", ",", "3", ",", "4"}], 
        "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], "\n", 
   RowBox[{"MatrixRank", "[", 
    RowBox[{"A", "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "3"}], "]"}], "]"}], "]"}], "\n", 
   RowBox[{"MatrixRank", "[", "A", "]"}], "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Verificaci\[OAcute]n", " ", "de", " ", "la", " ", 
     "combinaci\[OAcute]n"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"2", "*", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0", ",", "1", ",", "1", ",", "1"}], 
      "}"}]}], "+", 
    RowBox[{"1", "*", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "+", 
    RowBox[{"1", "*", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}], ",", "3"}], "}"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.972483106269267*^9, 3.972483106270974*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"6ea0c7e4-e057-459d-99e7-b8c0816ce19f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      RowBox[{"-", 
       FractionBox["1", "3"]}], 
      RowBox[{"-", 
       FractionBox["1", "3"]}], 
      FractionBox["1", "3"]},
     {"0", "1", "0", 
      FractionBox["2", "3"], 
      FractionBox["2", "3"], 
      FractionBox["1", "3"]},
     {"0", "0", "1", 
      FractionBox["4", "3"], 
      FractionBox["10", "3"], 
      RowBox[{"-", 
       FractionBox["4", "3"]}]},
     {"0", "0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.972483107551484*^9},
 CellLabel->
  "Out[11]//MatrixForm=",ExpressionUUID->"6fb4e0ac-5449-4d63-b4f0-\
264dea02f42b"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972483107552245*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"44c3f1f1-3f98-43fa-ab21-2ca4ce625eaf"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972483107552513*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"7a422508-f759-480d-a9f8-417c11a4b9e9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "7", ",", "0", ",", "3", ",", "3", ",", "4"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.972483107552814*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"9d5fd077-f258-48e9-9d21-6eb1fe1469ca"]
}, Open  ]],

Cell["\<\
4. \[DownQuestion]Es f(x) = e\:02e3 combinaci\[OAcute]n lineal de {sin(x), \
cos(x), x\.b2} en C[0, 2\[Pi]]?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.972483116537775*^9},ExpressionUUID->"1cc800bd-c632-49e4-af77-\
f967a2691b7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Evaluamos", " ", "en", " ", "puntos", " ", "espec\[IAcute]ficos", " ", 
    "para", " ", "verificar", " ", "inconsistencia"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"Exp", "[", "x", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "[", "x_", "]"}], ":=", 
     RowBox[{"Sin", "[", "x", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"g2", "[", "x_", "]"}], ":=", 
     RowBox[{"Cos", "[", "x", "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"g3", "[", "x_", "]"}], ":=", 
     RowBox[{"x", "^", "2"}]}], ";"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Sistema", " ", "de", " ", "ecuaciones", " ", "evaluando", " ", "en", " ",
        "x"}], "=", "0"}], ",", 
     RowBox[{"\[Pi]", "/", "2"}], ",", "\[Pi]"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq1", "=", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"g1", "[", "0", "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"g2", "[", "0", "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"g3", "[", "0", "]"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq2", "=", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"Pi", "/", "2"}], "]"}], "==", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"g1", "[", 
         RowBox[{"Pi", "/", "2"}], "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"g2", "[", 
         RowBox[{"Pi", "/", "2"}], "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"g3", "[", 
         RowBox[{"Pi", "/", "2"}], "]"}]}]}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"eq3", "=", 
     RowBox[{
      RowBox[{"f", "[", "Pi", "]"}], "==", 
      RowBox[{
       RowBox[{"a", "*", 
        RowBox[{"g1", "[", "Pi", "]"}]}], "+", 
       RowBox[{"b", "*", 
        RowBox[{"g2", "[", "Pi", "]"}]}], "+", 
       RowBox[{"c", "*", 
        RowBox[{"g3", "[", "Pi", "]"}]}]}]}]}], ";"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"eq1", ",", "eq2", ",", "eq3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
    "Verificaci\[OAcute]n", " ", "en", " ", "otro", " ", "punto", " ", "para",
      " ", "mostrar", " ", "inconsistencia"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sol", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"E", "^", 
           RowBox[{"(", 
            RowBox[{"Pi", "/", "2"}], ")"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Pi", "^", "2"}], "*", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{"E", "^", "Pi"}]}], ")"}]}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"4", "*", 
             RowBox[{"Pi", "^", "2"}]}], ")"}]}]}], ")"}]}], ",", 
       RowBox[{"b", "->", "1"}], ",", 
       RowBox[{"c", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"E", "^", "Pi"}]}], ")"}], "/", 
         RowBox[{"Pi", "^", "2"}]}]}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", "*", 
         RowBox[{"g1", "[", "1", "]"}]}], "+", 
        RowBox[{"b", "*", 
         RowBox[{"g2", "[", "1", "]"}]}], "+", 
        RowBox[{"c", "*", 
         RowBox[{"g3", "[", "1", "]"}]}]}], ")"}]}], "/.", " ", "sol"}], "//",
     "Simplify"}]}]}]], "Input",
 CellChangeTimes->{{3.972483121359223*^9, 3.9724831213608932`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"4ee1c545-4aa4-4a3d-8e53-43774d0753c0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[Pi]", "/", "2"}]]}], "-", 
        SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], ")"}]}]}], ",", 
    RowBox[{"b", "\[Rule]", "1"}], ",", 
    RowBox[{"c", "\[Rule]", 
     FractionBox[
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
      SuperscriptBox["\[Pi]", "2"]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972483122568254*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"927677b5-fa1b-4299-aa93-c52d66d79d4f"],

Cell[BoxData[
 RowBox[{"\[ExponentialE]", "-", 
  FractionBox[
   RowBox[{"1", "+", 
    SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], 
   SuperscriptBox["\[Pi]", "2"]], "-", 
  RowBox[{"Cos", "[", "1", "]"}], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"4", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[Pi]", "/", "2"}]]}], "+", 
     SuperscriptBox["\[ExponentialE]", "\[Pi]"]}], ")"}], " ", 
   RowBox[{"Sin", "[", "1", "]"}]}]}]], "Output",
 CellChangeTimes->{3.972483122592648*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"7be57208-2735-4aca-aa5e-d353d07e6ccc"]
}, Open  ]],

Cell["\<\
5. \[DownQuestion]Es x\:2074 + 2x\.b3 + x\.b2 - 4x + 6 combinaci\[OAcute]n \
lineal de {x\:2074 + 2x\.b2 - 1, x\.b3 - x + 3, 3x\:2074 - x\.b3 + x\.b2 + 2, \
x\.b2 + 2x - 1} en P\:2084(\:211d)?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.97248314413719*^9},ExpressionUUID->"71e16bfc-2e37-4687-9e85-\
0a6ec9c8f0b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Matriz", " ", "de", " ", 
    RowBox[{"coeficientes", ":", 
     RowBox[{"cada", " ", "fila", " ", 
      RowBox[{"representa", "[", 
       RowBox[{
       "x\:2074", ",", "x\.b3", ",", "x\.b2", ",", "x", ",", "constante"}], 
       "]"}]}]}]}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"A", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "2", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0", ",", 
         RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1", ",", "2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1", ",", 
         RowBox[{"-", "4"}], ",", "6"}], "}"}]}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], "\n", 
   RowBox[{"MatrixRank", "[", 
    RowBox[{"A", "[", 
     RowBox[{"[", 
      RowBox[{"1", ";;", "4"}], "]"}], "]"}], "]"}], "\n", 
   RowBox[{"MatrixRank", "[", "A", "]"}], "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Verificaci\[OAcute]n", " ", "de", " ", "la", " ", 
       "combinaci\[OAcute]n", " ", "\[Alpha]"}], "=", "1"}], ",", 
     RowBox[{"\[Beta]", "=", "2"}], ",", 
     RowBox[{"\[Gamma]", "=", "0"}], ",", 
     RowBox[{"\[Delta]", "=", 
      RowBox[{"-", "1"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"1", "*", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "2", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "+", 
    RowBox[{"2", "*", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "+", 
    RowBox[{"0", "*", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "2"}], "}"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "*", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "2", ",", 
       RowBox[{"-", "1"}]}], "}"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.972483150167017*^9, 3.972483150168889*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"9363f431-b086-49fe-ab85-a0f6acd5ac32"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", 
      FractionBox["7", "3"]},
     {"0", "1", "0", "0", 
      FractionBox["10", "3"]},
     {"0", "0", "1", "0", 
      RowBox[{"-", 
       FractionBox["5", "3"]}]},
     {"0", "0", "0", "1", 
      FractionBox["1", "3"]},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.972483153299624*^9},
 CellLabel->
  "Out[26]//MatrixForm=",ExpressionUUID->"303f3182-890f-4f5c-821f-\
cce6a6c02216"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.972483153301363*^9},
 CellLabel->"Out[27]=",ExpressionUUID->"72c5fe11-c82b-434a-b372-0eda41189bc1"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.972483153301918*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"ecdbd24b-83d2-416b-92f6-13b6bc51d37b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "1", ",", 
   RowBox[{"-", "4"}], ",", "6"}], "}"}]], "Output",
 CellChangeTimes->{3.972483153302513*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"47e0e637-221c-4cd3-bed3-60d2e85fde6e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dependencia e independencia lineal", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 3.972475734361013*^9}, {
  3.972475765023363*^9, 
  3.972475771384164*^9}},ExpressionUUID->"a63d40cb-deb7-429a-b5dd-\
50e70a9c4b5a"],

Cell["\<\
1. Determinar si el conjunto de vectores 
{(1, 2, 1, 3), (2, 1, -1, 1), (1, -1, 3, 2), (3, 1, 2, -1)} 
en R^4 es linealmente independiente.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.9724849543175917`*^9, 
   3.972489267156918*^9},ExpressionUUID->"d682799c-ccf6-49f1-82b4-\
e0b5341f44c1"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "3", ",", "2"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v4", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"M", "=", 
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2", ",", "v3", ",", "v4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Det", "[", "M", "]"}]}], "Input",
 CellChangeTimes->{{3.972484959763082*^9, 3.972484961551313*^9}, 
   3.972488893539715*^9, {3.9724889336848927`*^9, 3.972488936122528*^9}, {
   3.972489015285438*^9, 3.972489022632327*^9}, {3.972489125750835*^9, 
   3.972489173221325*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"cb84b649-86a4-4b3c-89bf-6ea09959d72c"],

Cell[BoxData["73"], "Output",
 CellChangeTimes->{
  3.972488896872884*^9, 3.972488936609084*^9, 3.972489023395689*^9, {
   3.972489146376049*^9, 3.972489174188787*^9}, 3.9724892962304077`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"ad376cf2-0900-448e-b5aa-b7853fd3d779"]
}, Open  ]],

Cell["\<\
2. Determinar si las matrices A1, A2 y A3 dadas son linealmente \
independientes en M3(R).\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.97248936386092*^9},ExpressionUUID->"ae0c6948-8cc2-430f-aacf-\
20ce19788034"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"Flatten", "[", "A1", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"Flatten", "[", "A2", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"Flatten", "[", "A3", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", 
  RowBox[{"{", 
   RowBox[{"v1", ",", "v2", ",", "v3"}], "}"}], "]"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", " ", "v1"}], "+", 
     RowBox[{"\[Beta]", " ", "v2"}], "+", 
     RowBox[{"\[Gamma]", " ", "v3"}]}], "==", 
    RowBox[{"ConstantArray", "[", 
     RowBox[{"0", ",", "9"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.972489369230475*^9, 3.972489386890883*^9}, 
   3.97248942044871*^9},
 CellLabel->"In[84]:=",ExpressionUUID->"e397df2d-00dc-4bb7-a163-d00adb214e79"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{{3.972489372374865*^9, 3.972489382722206*^9}, 
   3.97248942539194*^9},
 CellLabel->"Out[90]=",ExpressionUUID->"944de56c-9cd5-480d-9519-e09a69a4d0e3"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    91, 3, 34517501114394283922, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.972489372392647*^9, 3.972489382723013*^9}, 
   3.972489425392645*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[84]:=",ExpressionUUID->"f0b6c0a0-b1b8-4a8e-a67f-0bd679de6328"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Beta]", "\[Rule]", "\[Alpha]"}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     RowBox[{"-", "\[Alpha]"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.972489372374865*^9, 3.972489382722206*^9}, 
   3.972489425395399*^9},
 CellLabel->"Out[91]=",ExpressionUUID->"6183c3d4-e891-4a7f-8333-9b42077bd7d3"]
}, Open  ]],

Cell["\<\
3. Determinar si el conjunto {sin(x) cos(x), sin(x)^2, cos(x)^2, 1} es \
linealmente dependiente en el espacio de funciones continuas.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.972489464030408*^9},ExpressionUUID->"684ee97c-b5ea-43cc-957d-\
20f44f56d647"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "^", "2"}], ",", "1"}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a1", " ", 
      RowBox[{"f", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "+", 
     RowBox[{"a2", " ", 
      RowBox[{"f", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "+", 
     RowBox[{"a3", " ", 
      RowBox[{"f", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], "+", "a4"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724894690615797`*^9, 3.9724894704993277`*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"60132d3f-3468-41ef-85b2-9250b0388435"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    93, 4, 34517501114394283922, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.972489470856474*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[92]:=",ExpressionUUID->"f25c8061-5fac-4ed4-a330-a52bae37ac41"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a4", "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "a3"}], " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"]}], "-", 
     RowBox[{"a1", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"a2", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.9724894708637133`*^9},
 CellLabel->"Out[93]=",ExpressionUUID->"f019c512-881b-4ec7-bba0-b3e5d433be7b"]
}, Open  ]],

Cell["\<\
4. Determinar para qu\[EAcute] valores de a los polinomios p1 = x^2 + a x + \
1, p2 = x^2 + x + a y p3 = a x^2 + x + 1 son linealmente independientes.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.972489505850156*^9},ExpressionUUID->"b696348c-fdd0-4429-a4c7-\
f0815f1d7c9b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "a"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Det", "[", 
    RowBox[{"{", 
     RowBox[{"p1", ",", "p2", ",", "p3"}], "}"}], "]"}], "//", "Simplify"}], "//",
   "Factor"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{"%", "==", "0"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724895125778513`*^9, 3.972489611029725*^9}},
 CellLabel->
  "In[113]:=",ExpressionUUID->"32f4801c-ce10-4ec1-8d20-63c37a828945"],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "a"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "a"}], ")"}]}]], "Output",
 CellChangeTimes->{{3.972489518136413*^9, 3.972489611645205*^9}},
 CellLabel->
  "Out[116]=",ExpressionUUID->"b0a8584e-2528-4664-8ee6-730e7920afd0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972489518136413*^9, 3.972489611645686*^9}},
 CellLabel->
  "Out[117]=",ExpressionUUID->"e22d847d-ce7b-4ada-bac1-6fc7b9332306"]
}, Open  ]],

Cell["\<\
5. Determinar si las funciones e^x, x e^x, x^2 e^x y e^(2x) son linealmente \
independientes.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.972489703979785*^9},ExpressionUUID->"5c0174e2-5dde-49c2-ad9c-\
5895ce3aa5ef"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"x", " ", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Wronskian", "[", 
   RowBox[{"f", ",", "x"}], "]"}], "//", "Simplify"}]}], "Input",
 CellChangeTimes->{{3.972489709294739*^9, 3.972489710782959*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"3d92891b-4aa5-4997-a551-89c7a718ecb4"],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"5", " ", "x"}]]}]], "Output",
 CellChangeTimes->{3.972489711710182*^9},
 CellLabel->
  "Out[119]=",ExpressionUUID->"8e058f09-7244-4c78-a062-c7fe1b6e8156"]
}, Open  ]],

Cell["\<\
El Wronskiano es el determinante de la matriz formada por un conjunto de \
funciones y sus derivadas sucesivas. Si este determinante no es cero en alg\
\[UAcute]n punto, las funciones son linealmente independientes.\
\>", "Text",
 CellChangeTimes->{{3.972489814732188*^9, 
  3.972489821739421*^9}},ExpressionUUID->"62acc89d-0263-43f2-8abd-\
037851262ab4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Conjunto generador", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 3.972475734361013*^9}, {
  3.972475765023363*^9, 
  3.9724758012115793`*^9}},ExpressionUUID->"d44b6da5-7239-4ca7-8e43-\
139168afd070"],

Cell["\<\
1. Determine si el conjunto 
S = {{{1, 1, 0}, {0, 1, 1}},
  {{1, 0, 1}, {1, 0, 0}},
  {{0, 1, 1}, {0, 1, 0}},
  {{1, 1, 1}, {1, 1, 1}}} 
genera el espacio de matrices M_{2x3}(R).\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, {
   3.972490463698494*^9, 
   3.97249046898145*^9}},ExpressionUUID->"0072fe6a-f705-4760-9990-\
c53d254bd765"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"S", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
      "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixRank", "[", "S", "]"}]}], "Input",
 CellChangeTimes->{{3.9724904202803383`*^9, 3.972490420282069*^9}, {
  3.972490472482271*^9, 3.972490499556855*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"3d2dd5db-e238-4eca-8b4c-f07c4bdcd77e"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{3.972490500967815*^9, 3.972490549958143*^9},
 CellLabel->
  "Out[123]=",ExpressionUUID->"883ca998-6226-4fba-9f29-9e23cea28052"]
}, Open  ]],

Cell["\<\
2. Sea 
T = {p1(x) = x^3 + x^2 + 1, 
     p2(x) = 2x^3 - x^2 + 1, 
     p3(x) = 4x^3 + a x^2 + 3}
donde a es un par\[AAcute]metro real. Determinar para qu\[EAcute] valores de \
a el conjunto T genera un subespacio de dimensi\[OAcute]n m\[AAcute]xima.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, {3.9724909375990763`*^9, 3.972490947473695*^9}, {
   3.9724917040735073`*^9, 
   3.972491716574181*^9}},ExpressionUUID->"0b7f2b64-85fb-487c-a91b-\
7bbb74549c78"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"p1Vec", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"p2Vec", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"p3Vec", "[", "a_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "a", ",", "0", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", " ", "p1Vec"}], "+", 
     RowBox[{"\[Beta]", " ", "p2Vec"}], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"p3Vec", "[", "a", "]"}]}]}], "==", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", " ", "p1Vec"}], "+", 
     RowBox[{"\[Beta]", " ", "p2Vec"}], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"p3Vec", "[", "1", "]"}]}]}], "==", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9724917281522408`*^9, 3.972491728153833*^9}, {
  3.9724917845566397`*^9, 3.9724918128920794`*^9}},
 CellLabel->
  "In[252]:=",ExpressionUUID->"0756e42d-3964-4540-a9ca-f440827f55a2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "0"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "0"}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9724917294518547`*^9, {3.972491784939475*^9, 3.972491813270746*^9}},
 CellLabel->
  "Out[255]=",ExpressionUUID->"3d5390ab-d0b8-486e-8626-7885bc194fd0"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    256, 48, 34517501114394283922, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{{3.9724917849361277`*^9, 3.972491813271864*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[252]:=",ExpressionUUID->"e654ca78-8d42-4c0a-8da9-488bdf0e56b7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Beta]", "\[Rule]", 
     FractionBox["\[Alpha]", "2"]}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["\[Alpha]", "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.9724917294518547`*^9, {3.972491784939475*^9, 3.972491813275531*^9}},
 CellLabel->
  "Out[256]=",ExpressionUUID->"305166bf-02a1-4677-b07c-57534db409a4"]
}, Open  ]],

Cell["\<\
3. Verificar si el vector (2,0,-1,8) pertenece al subespacio generado por \
v1,v2,v3\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.972492114390082*^9},ExpressionUUID->"1898346a-83c5-447a-85bc-\
fc065c5cff81"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "2"}], ",", "2", ",", "1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "8"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", " ", "v1"}], "+", 
     RowBox[{"\[Beta]", " ", "v2"}], "+", 
     RowBox[{"\[Gamma]", " ", "v3"}]}], "==", "b"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.972492107914193*^9, 3.972492127845723*^9}},
 CellLabel->
  "In[263]:=",ExpressionUUID->"37930f07-365d-4b96-b3f9-f203bea090ce"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "2"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "1"}], ",", 
    RowBox[{"\[Gamma]", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.972492128632303*^9},
 CellLabel->
  "Out[267]=",ExpressionUUID->"724ae5a8-a699-4748-a10e-411824555e14"]
}, Open  ]],

Cell["\<\
4. Encuentre una base para el subespacio W generado por 
   las matrices {{1,2},{3,1}}, {{2,1},{1,3}}, {{3,3},{4,4}}, {{1,-1},{2,-2}} 
   en M_2(R) y determine su dimensi\[OAcute]n.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.972492218555685*^9},ExpressionUUID->"be99cbef-5902-4330-ac78-\
47cba1e2a917"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vecs", "=", 
   RowBox[{"Flatten", "/@", 
    RowBox[{"{", 
     RowBox[{"A1", ",", "A2", ",", "A3", ",", "A4"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Transpose", "[", "vecs", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rr", "=", 
   RowBox[{"RowReduce", "[", "mat", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pivots", "=", 
   RowBox[{"First", "/@", 
    RowBox[{"Position", "[", 
     RowBox[{
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Max", "[", 
          RowBox[{"Abs", "[", "#", "]"}], "]"}], "&"}], ",", "rr", ",", 
        RowBox[{"{", "1", "}"}]}], "]"}], ",", 
      RowBox[{"_", "?", "Positive"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"independentVectors", "=", 
   RowBox[{"vecs", "[", 
    RowBox[{"[", "pivots", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"basisMatrices", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "independentVectors"}]}], 
  ";"}], "\[IndentingNewLine]", "basisMatrices", "\n", 
 RowBox[{"Length", "[", "basisMatrices", "]"}]}], "Input",
 CellChangeTimes->{{3.9724923312920628`*^9, 3.9724923420110607`*^9}, {
  3.972492400513356*^9, 3.972492428684849*^9}},
 CellLabel->
  "In[289]:=",ExpressionUUID->"60cfb192-7b74-4b3c-8097-331f624d384a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972492254974662*^9, 3.972492332840377*^9, 
  3.972492429484036*^9},
 CellLabel->
  "Out[299]=",ExpressionUUID->"a70c18d2-cdc4-40eb-a413-e5f24b288996"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.972492254974662*^9, 3.972492332840377*^9, 
  3.972492429485106*^9},
 CellLabel->
  "Out[300]=",ExpressionUUID->"0d69e477-53e3-46e4-a6de-5c33f49f3b0e"]
}, Open  ]],

Cell["\<\
5. Determine si g(x)=3+2 Cos[2 x] pertenece al subespacio generado por \
f1(x)=Cos[x]^2,f2(x)=Sin[x]^2,f3(x)=Cos[2 x] en el espacio de funciones \
continuas\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.972492560125084*^9},ExpressionUUID->"961fe8ae-302f-489a-b2f3-\
20d0a5389a27"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "\n", 
 RowBox[{
  RowBox[{"f2", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], "\n", 
 RowBox[{
  RowBox[{"f3", "[", "x_", "]"}], ":=", 
  RowBox[{"Cos", "[", 
   RowBox[{"2", " ", "x"}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"3", "+", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Alpha]", " ", 
      RowBox[{"f1", "[", "x", "]"}]}], "+", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"f2", "[", "x", "]"}]}], "+", 
     RowBox[{"\[Gamma]", " ", 
      RowBox[{"f3", "[", "x", "]"}]}]}], "==", 
    RowBox[{"g", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}]}], 
  "]"}], "\n"}], "Input",
 CellChangeTimes->{{3.9724925223991203`*^9, 3.972492530685225*^9}},
 CellLabel->
  "In[301]:=",ExpressionUUID->"dc1b2f8d-f6b9-4ba9-9f6c-950e81bc99a9"],

Cell[BoxData[
 TemplateBox[{
  "Solve", "svars", 
   "\"Equations may not give solutions for all \\\"solve\\\" variables.\"", 2,
    305, 49, 34517501114394283922, "Local"},
  "MessageTemplate",
  BaseStyle->"MSG"]], "Message",
 CellChangeTimes->{3.972492531652814*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[301]:=",ExpressionUUID->"279aa1ae-a077-4a4a-a9e7-e4ec2414c01f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Gamma]", "\[Rule]", 
    RowBox[{"2", "+", 
     RowBox[{"3", " ", 
      RowBox[{"Sec", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], "-", 
     RowBox[{"\[Alpha]", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Sec", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], "-", 
     RowBox[{"\[Beta]", " ", 
      RowBox[{"Sec", "[", 
       RowBox[{"2", " ", "x"}], "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "2"]}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.97249253165576*^9},
 CellLabel->
  "Out[305]=",ExpressionUUID->"c0bf39a4-a16c-4339-b317-e7bd769889e2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Bases y dimensi\[OAcute]n", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 3.972475734361013*^9}, {
  3.972475765023363*^9, 
  3.972475828565714*^9}},ExpressionUUID->"876683c2-c208-4de9-84f9-\
05c9130dc515"],

Cell["\<\
1. Ejercicio: Determine una base para el subespacio 
W = {(x, y, z, w) \[Element] R^4 | 2x - y + z = 0 y x + y - w = 0} 
y calcule su dimensi\[OAcute]n.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972492903661812*^9},ExpressionUUID->"6ecc77f4-9a17-4bdd-8631-\
483cbf1d8062"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"sol", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", " ", "x"}], "-", "y", "+", "z"}], "==", "0"}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y", "-", "w"}], "==", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "w"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"vec", "=", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], "/.", " ", 
   RowBox[{"sol", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.972492912988563*^9, 3.9724929748248653`*^9}, {
  3.9724930125230227`*^9, 3.972493018491509*^9}, {3.972493057614665*^9, 
  3.972493059098048*^9}},
 CellLabel->
  "In[336]:=",ExpressionUUID->"1a10efc8-c6c3-4bc4-9a61-76c771ceeebd"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "x"}], "+", "y"}]}], ",", 
    RowBox[{"w", "\[Rule]", 
     RowBox[{"x", "+", "y"}]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9724929352819157`*^9, 3.9724929754191313`*^9}, {
   3.972493014376837*^9, 3.9724930188326063`*^9}, 3.972493059928111*^9},
 CellLabel->
  "Out[336]=",ExpressionUUID->"5472c355-084c-49e4-90b4-9de0f23d3f8c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", "x"}], "+", "y"}], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9724929352819157`*^9, 3.9724929754191313`*^9}, {
   3.972493014376837*^9, 3.9724930188326063`*^9}, 3.9724930599292593`*^9},
 CellLabel->
  "Out[337]=",ExpressionUUID->"6079bada-b040-4f23-909e-1590ddd4164e"]
}, Open  ]],

Cell["\<\
2. Sea V el subespacio de M_3(R) de todas las matrices sim\[EAcute]tricas 3x3. 
Determine una base para V y su dimensi\[OAcute]n.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, {3.9724931028541813`*^9, 
   3.972493104896288*^9}},ExpressionUUID->"85c59dcb-a5c8-4036-9d46-\
7c5ebb47f9d7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"B", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"(*", "E11", "*)"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"(*", 
     RowBox[{"E12", "+", "E21"}], "*)"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"(*", 
     RowBox[{"E13", "+", "E31"}], "*)"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"(*", "E22", "*)"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
    RowBox[{"(*", 
     RowBox[{"E23", "+", "E32"}], "*)"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "    ", 
   RowBox[{"(*", "E33", "*)"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "B", "]"}]}], "Input",
 CellChangeTimes->{{3.97249311108385*^9, 3.972493133287807*^9}, {
  3.972493165846855*^9, 3.9724931817568808`*^9}},
 CellLabel->
  "In[343]:=",ExpressionUUID->"5b3cc6fb-1c86-40fa-b781-e53b81f8e1a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972493125682056*^9, 3.972493134555584*^9}, 
   3.972493184963779*^9},
 CellLabel->
  "Out[343]=",ExpressionUUID->"ede97877-c47a-44d2-9a87-43a3c2eae974"],

Cell[BoxData["6"], "Output",
 CellChangeTimes->{{3.972493125682056*^9, 3.972493134555584*^9}, 
   3.97249318496483*^9},
 CellLabel->
  "Out[344]=",ExpressionUUID->"7f10a521-2bd3-4e0a-b178-4fa32fb120be"]
}, Open  ]],

Cell["\<\
3. Sea B = {1 + x, 1 - x, x^2} una base de P2(R). 
Determine las coordenadas del polinomio p(x) = 3 x^2 - 4 x + 2 respecto a \
esta base.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, {3.97249322474727*^9, 
   3.9724932283017187`*^9}},ExpressionUUID->"2d7c1ca4-6719-4217-9e1d-\
88f114e5d288"],

Cell[BoxData[
 RowBox[{"?", "Vector"}]], "Input",
 CellChangeTimes->{{3.972493318295165*^9, 
  3.972493320075185*^9}},ExpressionUUID->"da951164-1dc5-487e-a1d5-\
9736722946b5"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", 
     RowBox[{"1", "-", "x"}], ",", 
     RowBox[{"x", "^", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p", "=", 
   RowBox[{
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"4", " ", "x"}], "+", "2"}]}], ";"}], "\n", 
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "3"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.972493240962549*^9, 3.972493325807748*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"cdf428cf-0fcd-4845-a9cf-28d5fd7073db"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972493301210717*^9, 3.9724933271481743`*^9}},
 CellLabel->
  "Out[353]=",ExpressionUUID->"cc8b2a58-9e07-4886-8a50-1d41b5376c64"]
}, Open  ]],

Cell["\<\
4. Sea S = {p1(x) = x^2 + a x + 1, p2(x) = x + a, p3(x) = x^2 + 1} en P2(R). 
\[DownQuestion]Para qu\[EAcute] valores de a el conjunto S es una base de \
P2(R)?\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.9724934833326893`*^9},ExpressionUUID->"9377e73d-80c7-4fa5-8546-\
808545dbe3b6"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Symbol", "[", "\"\<a\>\"", "]"}]}], ";"}], "\n", 
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "a", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"%", "==", "0"}], ",", "a"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724934939911137`*^9, 3.9724935090108833`*^9}, {
  3.972493553101821*^9, 3.972493599985779*^9}, {3.972493691042716*^9, 
  3.972493699498849*^9}},
 CellLabel->
  "In[366]:=",ExpressionUUID->"81e5e26a-400e-4283-a7fe-2bce448629f6"],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 CellChangeTimes->{{3.972493554218392*^9, 3.972493604003121*^9}, 
   3.972493700285541*^9},
 CellLabel->
  "Out[367]=",ExpressionUUID->"7e1dc9d5-1440-43c6-8f79-ce18f32bea9a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.972493554218392*^9, 3.972493604003121*^9}, 
   3.9724937002865953`*^9},
 CellLabel->
  "Out[368]=",ExpressionUUID->"6396e16f-4809-4ab7-9dfc-76a4a9f33869"]
}, Open  ]],

Cell["\<\
5. Complete el conjunto linealmente independiente 
L = { {{1,2},{0,1}}, {{0,1},{1,0}} } a una base de M2(R).\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.97249376044378*^9},ExpressionUUID->"aa9cadd1-cbf3-46a1-87a2-\
252df067120d"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A3", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"L", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"L", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Flatten", "[", "A3", "]"}], ",", 
      RowBox[{"Flatten", "[", "A4", "]"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", "B", "]"}]}], "Input",
 CellChangeTimes->{{3.972493767932054*^9, 3.972493795101038*^9}, {
  3.9724938265613947`*^9, 3.972493968373537*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"c3740c5c-adc4-42b2-b815-254c6d35ae9e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9724937956412582`*^9, {3.972493867822137*^9, 3.972493901167115*^9}, {
   3.972493955573372*^9, 3.972493968913198*^9}},
 CellLabel->
  "Out[401]=",ExpressionUUID->"b61807ab-970b-4707-b4b4-09798c27b0a1"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.9724937956412582`*^9, {3.972493867822137*^9, 3.972493901167115*^9}, {
   3.972493955573372*^9, 3.972493968914542*^9}},
 CellLabel->
  "Out[402]=",ExpressionUUID->"3536698f-cc2e-42f9-a523-b1af251b7a34"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vector de coordenadas", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 3.972475734361013*^9}, {
  3.972475765023363*^9, 3.972475828565714*^9}, {3.972475865392956*^9, 
  3.972475870778015*^9}},ExpressionUUID->"16c08065-5726-4273-b083-\
93f91b74b8e1"],

Cell["\<\
1. Sea B = {(1,1,0), (1,0,1), (0,1,1)} una base de R^3. 
Determine las coordenadas del vector (3,2,1) respecto a B.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972494355007969*^9},ExpressionUUID->"b7f30c82-de20-4e26-95fb-\
4a65d1d47020"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9724943573262787`*^9, 3.972494394704018*^9}},
 CellLabel->
  "In[403]:=",ExpressionUUID->"8ea1014d-bacf-4392-9126-11b9a35ca005"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "0", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972494395595581*^9},
 CellLabel->
  "Out[403]=",ExpressionUUID->"78d8288e-b32c-44dc-8b6c-b77e52d95154"]
}, Open  ]],

Cell["\<\
2. Sea B = {1 + x, 1 - x, x^2} una base de P2(R). 
Determine las coordenadas del polinomio x^2 + 2 x + 3 respecto a B.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.972494575472508*^9},ExpressionUUID->"9e079cd2-0fbc-47fd-b89d-\
e7b0c01e123b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9724945826766148`*^9, 3.972494613805874*^9}},
 CellLabel->
  "In[404]:=",ExpressionUUID->"3a8e8198-cf9c-49d9-a547-fcb2d090bd99"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["5", "2"], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["1", "2"], "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972494618571628*^9},
 CellLabel->
  "Out[404]=",ExpressionUUID->"730fa944-2500-4e95-88c8-26462f8574e5"]
}, Open  ]],

Cell["\<\
3. Sea B = { {{1,0},{0,0}}, {{0,1},{0,0}}, {{0,0},{1,0}}, {{0,0},{0,1}} } 
la base est\[AAcute]ndar de M_2(R). Determine las coordenadas de la matriz 
{{2,3},{1,4}} respecto a B.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, 
   3.972494689229129*^9},ExpressionUUID->"b75388b4-3ccc-44eb-bb0f-\
6f89fd290c22"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Bbase", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"Bvecs", "=", 
  RowBox[{"Flatten", "/@", "Bbase"}]}], "\[IndentingNewLine]", 
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", "A", "]"}], ",", "Bvecs", ",", "4"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.972494705741775*^9, 3.972494723295999*^9}},
 CellLabel->
  "In[409]:=",ExpressionUUID->"7a64ba66-a989-4527-8d81-9fb72a38b84c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9724947167244596`*^9, 3.972494724143774*^9}},
 CellLabel->
  "Out[411]=",ExpressionUUID->"25615dcb-fa2e-4606-a558-6138c12e9089"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9724947167244596`*^9, 3.97249472414505*^9}},
 CellLabel->
  "Out[412]=",ExpressionUUID->"18cb2fd9-6370-4d9b-b716-3f1862173a9e"]
}, Open  ]],

Cell["\<\
4. En el subespacio W = { (x,y,z,w) \[Element] R^4 / x + y = 0 } con base 
B = {(-1, 1, 0, 0), (0, 0, 1, 0), (0, 0, 0, 1)}. 
Determine las coordenadas de (-2, 2, 3, -1) respecto a B.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, {3.972494810093172*^9, 
   3.972494825584087*^9}},ExpressionUUID->"2142f96d-7054-4226-b404-\
710954ba0cfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "2", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}], ",", "3"}],
   "]"}]], "Input",
 CellChangeTimes->{{3.9724948298759613`*^9, 3.9724948696198587`*^9}},
 CellLabel->
  "In[413]:=",ExpressionUUID->"4a95541f-066e-4913-bebf-220697fd3c19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.972494870168441*^9},
 CellLabel->
  "Out[413]=",ExpressionUUID->"93ae14fb-5202-4fe5-bcbf-ff5446139565"]
}, Open  ]],

Cell["\<\
5. Sea B = {x - 1, (x - 1)^2, (x - 1)^3} una base del subespacio
V = {p(x) \[Element] P3(R) : p(1) = 0}. Determine las coordenadas de 
x^3 - 3x^2 + 3x - 1 respecto a B.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.972494921810196*^9},ExpressionUUID->"aecb6604-f0cf-4cd2-acb6-\
91c03d89b0ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VectorCoordenadas", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "3"}], ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "3"}], ",", "3", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.9724949597243633`*^9, 3.972495035600547*^9}},
 CellLabel->
  "In[415]:=",ExpressionUUID->"aff3cbb4-cae1-47d8-a101-624ccbb6c706"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "1", "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.97249503643692*^9},
 CellLabel->
  "Out[415]=",ExpressionUUID->"bb16f1c2-e3e3-4d56-8c6d-0dda39448dcf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Completaci\[OAcute]n de bases", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 3.971268806415683*^9}, {
  3.972060262404065*^9, 3.972060265894546*^9}, {3.9724756213905697`*^9, 
  3.972475632704076*^9}, {3.972475722214245*^9, 3.972475734361013*^9}, {
  3.972475765023363*^9, 3.972475828565714*^9}, {3.972475865392956*^9, 
  3.9724758810820913`*^9}},ExpressionUUID->"8a4ed504-e802-451a-adf8-\
4f989bde8f46"],

Cell["\<\
1. Complete el conjunto L = {(1,0,1), (0,1,1)} a una base de R^3. \
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, 3.972475593150096*^9, 
   3.972495380830738*^9},ExpressionUUID->"10ed39f7-4f3a-4517-abb4-\
e46f077c2eea"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Append", "[", 
   RowBox[{"L", ",", "v"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Det", "[", "B", "]"}], "\n", 
 RowBox[{"CompletandoBase", "[", 
  RowBox[{"L", ",", "3"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972495389040349*^9, 3.9724954200932837`*^9}, 
   3.972496392393181*^9, 3.9724964691337147`*^9},
 CellLabel->
  "In[536]:=",ExpressionUUID->"4d7eb1f7-e9a3-42c6-9785-3256457d9d9f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9724954213213263`*^9, 3.972496393967922*^9, 
  3.972496473064501*^9},
 CellLabel->
  "Out[538]=",ExpressionUUID->"1e46b6b7-5180-4a64-81e5-e03b675323c4"],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{3.9724954213213263`*^9, 3.972496393967922*^9, 
  3.972496473065558*^9},
 CellLabel->
  "Out[539]=",ExpressionUUID->"685c1f34-1304-4950-9012-38a17c714289"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La base buscada se encuentra contenida en la matriz: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "1"},
       {"0", "1", "1"},
       {"1", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["La base buscada se encuentra contenida en la matriz: ", 
   MatrixForm[{{1, 0, 1}, {0, 1, 1}, {1, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.97249542132271*^9, 3.972496393970199*^9, 
  3.972496473066362*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[536]:=",ExpressionUUID->"b0b47099-795a-42b8-aff3-cff4ab4852e8"]
}, Open  ]],

Cell["2. Complete el conjunto L = {x^2, x^3} a una base de P3(R). ", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475602989459*^9}, 
   3.972495470158084*^9},ExpressionUUID->"972a7b9d-6083-4234-9e77-\
a82481015f3c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"extra", ",", "L"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompletandoBase", "[", 
  RowBox[{"L", ",", "4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724954824770403`*^9, 3.972495520076391*^9}, {
  3.9724959184384212`*^9, 3.9724959257426147`*^9}, {3.972496439040265*^9, 
  3.972496465354048*^9}},
 CellLabel->
  "In[541]:=",ExpressionUUID->"28d53646-0d3c-4a9a-9cb4-3b00c9ef9ed8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.972495483955608*^9, 3.972495520804443*^9, 3.972495926045595*^9, {
   3.97249646308735*^9, 3.972496477088089*^9}},
 CellLabel->
  "Out[543]=",ExpressionUUID->"1c9372a5-6e0a-43be-8113-9ded9fe041ec"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{
  3.972495483955608*^9, 3.972495520804443*^9, 3.972495926045595*^9, {
   3.97249646308735*^9, 3.972496477089081*^9}},
 CellLabel->
  "Out[544]=",ExpressionUUID->"1f09a881-9910-4efd-9050-b477a7400c72"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La base buscada se encuentra contenida en la matriz: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "0", "0"},
       {"1", "0", "0", "0"},
       {"0", "0", "0", "1"},
       {"1", "1", "1", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["La base buscada se encuentra contenida en la matriz: ", 
   MatrixForm[{{0, 1, 0, 0}, {1, 0, 0, 0}, {0, 0, 0, 1}, {1, 1, 1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.9724955208058243`*^9, 3.972495926047814*^9, {3.972496463089485*^9, 
   3.972496477089966*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[541]:=",ExpressionUUID->"01ca1724-2cf4-4f57-9cc8-e8387a60a1cf"]
}, Open  ]],

Cell["\<\
3. Complete el conjunto L = {{1,1},{0,0}}, {{0,0},{1,1}} a una base de M2(R).\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.972475605523734*^9}, {3.972495583140356*^9, 
   3.972495586750959*^9}},ExpressionUUID->"a0435d51-1eb5-414f-8f79-\
53e093d378df"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"Flatten", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"Flatten", "/@", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"L", ",", "extra"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"baseMatrices", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "B"}]}], 
  ";"}], "\[IndentingNewLine]", "baseMatrices", "\[IndentingNewLine]", 
 RowBox[{"CompletandoBase", "[", 
  RowBox[{"L", ",", "4"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724955971628857`*^9, 3.972495645616603*^9}, {
   3.9724958453143806`*^9, 3.972495864693494*^9}, {3.972496234077608*^9, 
   3.9724962370033417`*^9}, 
   3.9724965606325073`*^9},ExpressionUUID->"f26b940d-3720-454d-9f88-\
2cf0347fd68c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9724956163772087`*^9, 3.972495646022315*^9}, {
   3.972495853461342*^9, 3.972495865046089*^9}, 3.972496241353322*^9},
 CellLabel->
  "Out[521]=",ExpressionUUID->"c88e083e-9b85-4916-a9f0-59c33d443b40"],

Cell[BoxData["4"], "Output",
 CellChangeTimes->{{3.9724956163772087`*^9, 3.972495646022315*^9}, {
   3.972495853461342*^9, 3.972495865046089*^9}, 3.9724962413545732`*^9},
 CellLabel->
  "Out[522]=",ExpressionUUID->"efced2b9-58fc-4f96-9398-45f96696367b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9724956163772087`*^9, 3.972495646022315*^9}, {
   3.972495853461342*^9, 3.972495865046089*^9}, 3.972496241355425*^9},
 CellLabel->
  "Out[524]=",ExpressionUUID->"f21e2de5-9d82-4279-8d87-c21ad43b7510"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La base buscada se encuentra contenida en la matriz: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "0", "0"},
       {"0", "0", "1", "1"},
       {"0", "1", "1", "1"},
       {"0", "1", "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["La base buscada se encuentra contenida en la matriz: ", 
   MatrixForm[{{1, 1, 0, 0}, {0, 0, 1, 1}, {0, 1, 1, 1}, {0, 1, 0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.972495646023937*^9, {3.9724958534634943`*^9, 3.9724958650489264`*^9}, 
   3.972496241356312*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[519]:=",ExpressionUUID->"959b9e41-7e40-4b0c-8351-1e60387ae5ce"]
}, Open  ]],

Cell["\<\
4. En el subespacio W = {(x, y, z, w) \[Element] R^4 | x + y = 0, z - w = 0}, 
complete el conjunto L = {(-1, 1, 1, 1)} a una base de W. \
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756073995447`*^9}, 
   3.972495710006304*^9},ExpressionUUID->"3ddf9290-2343-48b5-9c9a-\
47b152427a4b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"L", ",", "extra"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", "B", "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompletandoBase", "[", 
  RowBox[{"L", ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.972495719548663*^9, 3.972495770388578*^9}, {
  3.97249582543659*^9, 3.972495831813025*^9}, {3.972495956870929*^9, 
  3.972495967039651*^9}},
 CellLabel->
  "In[546]:=",ExpressionUUID->"cab4b624-ab5c-4468-9504-04c3ca793694"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.972495770895404*^9, 3.972495832246636*^9, {3.9724959579225273`*^9, 
   3.972495967824444*^9}, 3.972496629158093*^9},
 CellLabel->
  "Out[548]=",ExpressionUUID->"691c6906-6a12-4178-bb1f-47d7a89fa5eb"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{
  3.972495770895404*^9, 3.972495832246636*^9, {3.9724959579225273`*^9, 
   3.972495967824444*^9}, 3.972496629159279*^9},
 CellLabel->
  "Out[549]=",ExpressionUUID->"2fdbce58-5c77-43ac-9513-34cfd2a3e7bc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La base buscada se encuentra contenida en la matriz: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1"}], "1", "1", "1"},
       {"0", "1", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["La base buscada se encuentra contenida en la matriz: ", 
   MatrixForm[{{-1, 1, 1, 1}, {0, 1, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.972495770897094*^9, 3.972495832248823*^9, {3.972495957923904*^9, 
   3.9724959678264*^9}, 3.972496629160166*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[546]:=",ExpressionUUID->"bd3b47aa-f919-46d1-a045-e5381595e4c6"]
}, Open  ]],

Cell["\<\
5. En el espacio de polinomios P2(R), complete el conjunto 
L = {x^2 + x, x - 1} a una base.\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905022612*^9, 3.96039050266572*^9}, 3.972060280567486*^9, {
   3.9721136360247717`*^9, 3.9721136487880793`*^9}, {3.972475593150096*^9, 
   3.9724756095149393`*^9}, 
   3.972496014003273*^9},ExpressionUUID->"cb786ef7-7b6d-4b07-a190-\
88d9a4dafd51"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "x"}], ",", 
     RowBox[{"x", "-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"extra", "=", 
   RowBox[{"{", "1", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"B", "=", 
  RowBox[{"Join", "[", 
   RowBox[{"L", ",", "extra"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MatrixRank", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"CompletandoBase", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], ",", "3"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9724960201354856`*^9, 3.972496160859561*^9}, 
   3.97249669368202*^9, 3.972496751569346*^9},
 CellLabel->
  "In[566]:=",ExpressionUUID->"728b7608-a1aa-4d9a-9e1e-2ec317f2f9bb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.972496082731306*^9, 3.972496092927669*^9}, {
   3.9724961499047527`*^9, 3.972496186072927*^9}, 3.972496694590753*^9, 
   3.972496751946846*^9, {3.972496782156992*^9, 3.972496783921742*^9}},
 CellLabel->
  "Out[568]=",ExpressionUUID->"0228ae0c-1932-43a0-be48-d8b2878b3f5a"],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{{3.972496082731306*^9, 3.972496092927669*^9}, {
   3.9724961499047527`*^9, 3.972496186072927*^9}, 3.972496694590753*^9, 
   3.972496751946846*^9, {3.972496782156992*^9, 3.972496783923008*^9}},
 CellLabel->
  "Out[569]=",ExpressionUUID->"86398f85-8d54-47cf-ad34-fdf1e5f44992"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"La base buscada se encuentra contenida en la matriz: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "0"},
       {"0", "1", 
        RowBox[{"-", "1"}]},
       {"0", "1", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["La base buscada se encuentra contenida en la matriz: ", 
   MatrixForm[{{1, 1, 0}, {0, 1, -1}, {0, 1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.97249606082612*^9, 3.97249609292912*^9}, {
   3.972496149905965*^9, 3.972496186074527*^9}, 3.9724966945922213`*^9, 
   3.9724967519492083`*^9, {3.972496782159006*^9, 3.972496783923963*^9}},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[566]:=",ExpressionUUID->"a7f2e62f-ab6a-4573-85a9-e09743d2c541"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1320, 776},
WindowMargins->{{Automatic, 115}, {Automatic, 117}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 199, 3, 73, "Input",ExpressionUUID->"970a1b2c-573e-c142-96c5-8eadc9eb8bfb"],
Cell[782, 27, 1025, 30, 107, "Print",ExpressionUUID->"78406d83-d2c6-4034-8055-12114e7c4303"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1844, 62, 422, 6, 165, "Section",ExpressionUUID->"0784176a-7fce-4cb4-93d2-7079f97c3024"],
Cell[2269, 70, 1727, 44, 261, "Text",ExpressionUUID->"cc6088f1-c4a0-4654-8595-5b2d2b17c27e"],
Cell[3999, 116, 288, 6, 139, "Text",ExpressionUUID->"4c022d68-c9a2-4542-a99d-34538039ab50"],
Cell[4290, 124, 1441, 33, 202, "Text",ExpressionUUID->"6f1c9b23-7657-45ef-bd5b-9d16258f4005"],
Cell[5734, 159, 284, 7, 139, "Text",ExpressionUUID->"70c4bf74-185e-478e-90e9-169438afb541"],
Cell[6021, 168, 706, 12, 193, "Text",ExpressionUUID->"1c0301e4-b359-4e4e-af2c-6a4286c4ef2d"],
Cell[6730, 182, 449, 9, 248, "Text",ExpressionUUID->"70ceae64-ac8f-41ac-8282-3ee08c1e05ca"],
Cell[7182, 193, 1865, 46, 320, "Text",ExpressionUUID->"d57b1efe-29e7-4771-a090-3317f0ca350b"],
Cell[9050, 241, 331, 7, 193, "Text",ExpressionUUID->"65849bfb-f651-46e9-bca2-76adad775a4e"],
Cell[9384, 250, 1450, 33, 249, "Text",ExpressionUUID->"c4944303-c495-4464-8fd5-1a417e771152"],
Cell[10837, 285, 394, 8, 193, "Text",ExpressionUUID->"1112410e-eadf-4f4f-ae0b-1e91a3eaf440"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11268, 298, 423, 6, 165, "Section",ExpressionUUID->"936e6ed0-9145-4228-b084-b6b34af3ad0b"],
Cell[11694, 306, 558, 10, 84, "Text",ExpressionUUID->"75fcff9a-cd4d-4c6f-9fd9-04da53d46524"],
Cell[12255, 318, 435, 9, 248, "Text",ExpressionUUID->"2fc63711-64cc-4bb7-aeb2-2fa8da9d95b1"],
Cell[12693, 329, 592, 9, 84, "Text",ExpressionUUID->"d1837576-aa54-4d7f-8cb2-4d8f09af509a"],
Cell[13288, 340, 424, 9, 193, "Text",ExpressionUUID->"eaa41564-b65e-4d24-8dba-592b972bcccc"],
Cell[13715, 351, 600, 11, 84, "Text",ExpressionUUID->"756e49ad-738a-4985-90d3-625feb8d20f0"],
Cell[14318, 364, 375, 7, 193, "Text",ExpressionUUID->"19e9bb73-12f7-40e2-9e69-63f57a61f590"],
Cell[14696, 373, 572, 9, 84, "Text",ExpressionUUID->"72d9ac12-94e8-47b9-922c-626b72ca9e08"],
Cell[15271, 384, 315, 7, 193, "Text",ExpressionUUID->"cb65ba41-0d6e-4997-a161-7f6fbc51761a"],
Cell[15589, 393, 574, 9, 84, "Text",ExpressionUUID->"5bd125ae-2444-4079-a155-a4182354f5bb"],
Cell[16166, 404, 302, 6, 193, "Text",ExpressionUUID->"a5af3087-1abc-4786-9985-0a1b69ac2ef0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16505, 415, 466, 7, 165, "Section",ExpressionUUID->"3e1e591c-373e-434b-aa32-97214f710a73"],
Cell[16974, 424, 598, 10, 139, "Text",ExpressionUUID->"69c24e66-4bb8-48b0-a009-56b1eae2c27b"],
Cell[CellGroupData[{
Cell[17597, 438, 876, 23, 385, "Input",ExpressionUUID->"86acd821-b7af-44aa-9203-045af875e955"],
Cell[18476, 463, 765, 24, 262, "Output",ExpressionUUID->"493d79bf-9948-4287-9f4d-14216ad45cc3"],
Cell[19244, 489, 146, 2, 83, "Output",ExpressionUUID->"46faef2e-6c20-495c-b7ce-c95385469edb"],
Cell[19393, 493, 145, 2, 83, "Output",ExpressionUUID->"83ed6492-4418-4221-816e-5eb982e47ab0"]
}, Open  ]],
Cell[19553, 498, 647, 11, 139, "Text",ExpressionUUID->"a21fde74-5d82-428a-8946-11a2c1ca7b4d"],
Cell[CellGroupData[{
Cell[20225, 513, 1305, 35, 538, "Input",ExpressionUUID->"ef8729b8-4d16-4148-833f-f7deb72e668c"],
Cell[21533, 550, 693, 21, 235, "Output",ExpressionUUID->"f6f6716c-c63a-49f5-94cc-c7619d6c900a"],
Cell[22229, 573, 148, 2, 83, "Output",ExpressionUUID->"6343e9d8-9bc1-4f56-b150-005d8d37d217"],
Cell[22380, 577, 148, 2, 83, "Output",ExpressionUUID->"8fbf5cc0-1e73-46a6-9722-91cfcd94517b"]
}, Open  ]],
Cell[22543, 582, 662, 12, 144, "Text",ExpressionUUID->"c720e754-2f4d-484b-ada0-eef8389047f5"],
Cell[CellGroupData[{
Cell[23230, 598, 1897, 52, 645, "Input",ExpressionUUID->"6ea0c7e4-e057-459d-99e7-b8c0816ce19f"],
Cell[25130, 652, 1029, 33, 275, "Output",ExpressionUUID->"6fb4e0ac-5449-4d63-b4f0-264dea02f42b"],
Cell[26162, 687, 149, 2, 83, "Output",ExpressionUUID->"44c3f1f1-3f98-43fa-ab21-2ca4ce625eaf"],
Cell[26314, 691, 149, 2, 83, "Output",ExpressionUUID->"7a422508-f759-480d-a9f8-417c11a4b9e9"],
Cell[26466, 695, 237, 5, 83, "Output",ExpressionUUID->"9d5fd077-f258-48e9-9d21-6eb1fe1469ca"]
}, Open  ]],
Cell[26718, 703, 606, 11, 84, "Text",ExpressionUUID->"1cc800bd-c632-49e4-af77-f967a2691b7f"],
Cell[CellGroupData[{
Cell[27349, 718, 3961, 119, 1325, "Input",ExpressionUUID->"4ee1c545-4aa4-4a3d-8e53-43774d0753c0"],
Cell[31313, 839, 748, 21, 109, "Output",ExpressionUUID->"927677b5-fa1b-4299-aa93-c52d66d79d4f"],
Cell[32064, 862, 643, 17, 109, "Output",ExpressionUUID->"7be57208-2735-4aca-aa5e-d353d07e6ccc"]
}, Open  ]],
Cell[32722, 882, 689, 12, 139, "Text",ExpressionUUID->"71e16bfc-2e37-4687-9e85-0a6ec9c8f0b7"],
Cell[CellGroupData[{
Cell[33436, 898, 2447, 67, 747, "Input",ExpressionUUID->"9363f431-b086-49fe-ab85-a0f6acd5ac32"],
Cell[35886, 967, 870, 27, 331, "Output",ExpressionUUID->"303f3182-890f-4f5c-821f-cce6a6c02216"],
Cell[36759, 996, 149, 2, 83, "Output",ExpressionUUID->"72c5fe11-c82b-434a-b372-0eda41189bc1"],
Cell[36911, 1000, 149, 2, 83, "Output",ExpressionUUID->"ecdbd24b-83d2-416b-92f6-13b6bc51d37b"],
Cell[37063, 1004, 243, 5, 83, "Output",ExpressionUUID->"47e0e637-221c-4cd3-bed3-60d2e85fde6e"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37355, 1015, 523, 8, 165, "Section",ExpressionUUID->"a63d40cb-deb7-429a-b5dd-50e70a9c4b5a"],
Cell[37881, 1025, 635, 12, 193, "Text",ExpressionUUID->"d682799c-ccf6-49f1-82b4-e0b5341f44c1"],
Cell[CellGroupData[{
Cell[38541, 1041, 1065, 29, 361, "Input",ExpressionUUID->"cb84b649-86a4-4b3c-89bf-6ea09959d72c"],
Cell[39609, 1072, 271, 4, 83, "Output",ExpressionUUID->"ad376cf2-0900-448e-b5aa-b7853fd3d779"]
}, Open  ]],
Cell[39895, 1079, 585, 11, 139, "Text",ExpressionUUID->"ae0c6948-8cc2-430f-aacf-20ce19788034"],
Cell[CellGroupData[{
Cell[40505, 1094, 1869, 57, 669, "Input",ExpressionUUID->"e397df2d-00dc-4bb7-a163-d00adb214e79"],
Cell[42377, 1153, 198, 3, 83, "Output",ExpressionUUID->"944de56c-9cd5-480d-9519-e09a69a4d0e3"],
Cell[42578, 1158, 434, 11, 65, "Message",ExpressionUUID->"f0b6c0a0-b1b8-4a8e-a67f-0bd679de6328"],
Cell[43015, 1171, 378, 9, 83, "Output",ExpressionUUID->"6183c3d4-e891-4a7f-8333-9b42077bd7d3"]
}, Open  ]],
Cell[43408, 1183, 630, 11, 139, "Text",ExpressionUUID->"684ee97c-b5ea-43cc-957d-20f44f56d647"],
Cell[CellGroupData[{
Cell[44063, 1198, 974, 29, 194, "Input",ExpressionUUID->"60132d3f-3468-41ef-85b2-9250b0388435"],
Cell[45040, 1229, 384, 10, 65, "Message",ExpressionUUID->"f25c8061-5fac-4ed4-a330-a52bae37ac41"],
Cell[45427, 1241, 569, 16, 88, "Output",ExpressionUUID->"f019c512-881b-4ec7-bba0-b3e5d433be7b"]
}, Open  ]],
Cell[46011, 1260, 648, 11, 139, "Text",ExpressionUUID->"b696348c-fdd0-4429-a4c7-f0815f1d7c9b"],
Cell[CellGroupData[{
Cell[46684, 1275, 770, 23, 347, "Input",ExpressionUUID->"32f4801c-ce10-4ec1-8d20-63c37a828945"],
Cell[47457, 1300, 340, 10, 83, "Output",ExpressionUUID->"b0a8584e-2528-4664-8ee6-730e7920afd0"],
Cell[47800, 1312, 418, 12, 83, "Output",ExpressionUUID->"e22d847d-ce7b-4ada-bac1-6fc7b9332306"]
}, Open  ]],
Cell[48233, 1327, 591, 11, 139, "Text",ExpressionUUID->"5c0174e2-5dde-49c2-ad9c-5895ce3aa5ef"],
Cell[CellGroupData[{
Cell[48849, 1342, 628, 18, 194, "Input",ExpressionUUID->"3d92891b-4aa5-4997-a551-89c7a718ecb4"],
Cell[49480, 1362, 237, 6, 83, "Output",ExpressionUUID->"8e058f09-7244-4c78-a062-c7fe1b6e8156"]
}, Open  ]],
Cell[49732, 1371, 365, 7, 248, "Text",ExpressionUUID->"62acc89d-0263-43f2-8abd-037851262ab4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[50134, 1383, 509, 8, 165, "Section",ExpressionUUID->"d44b6da5-7239-4ca7-8e43-139168afd070"],
Cell[50646, 1393, 673, 15, 357, "Text",ExpressionUUID->"0072fe6a-f705-4760-9990-c53d254bd765"],
Cell[CellGroupData[{
Cell[51344, 1412, 782, 21, 207, "Input",ExpressionUUID->"3d2dd5db-e238-4eca-8b4c-f07c4bdcd77e"],
Cell[52129, 1435, 175, 3, 83, "Output",ExpressionUUID->"883ca998-6226-4fba-9f29-9e23cea28052"]
}, Open  ]],
Cell[52319, 1441, 824, 16, 357, "Text",ExpressionUUID->"0b7f2b64-85fb-487c-a91b-7bbb74549c78"],
Cell[CellGroupData[{
Cell[53168, 1461, 1540, 43, 505, "Input",ExpressionUUID->"0756e42d-3964-4540-a9ca-f440827f55a2"],
Cell[54711, 1506, 396, 10, 83, "Output",ExpressionUUID->"3d5390ab-d0b8-486e-8626-7885bc194fd0"],
Cell[55110, 1518, 413, 10, 65, "Message",ExpressionUUID->"e654ca78-8d42-4c0a-8da9-488bdf0e56b7"],
Cell[55526, 1530, 432, 12, 98, "Output",ExpressionUUID->"305166bf-02a1-4677-b07c-57534db409a4"]
}, Open  ]],
Cell[55973, 1545, 580, 11, 139, "Text",ExpressionUUID->"1898346a-83c5-447a-85bc-fc065c5cff81"],
Cell[CellGroupData[{
Cell[56578, 1560, 1059, 33, 310, "Input",ExpressionUUID->"37930f07-365d-4b96-b3f9-f203bea090ce"],
Cell[57640, 1595, 366, 10, 83, "Output",ExpressionUUID->"724ae5a8-a699-4748-a10e-411824555e14"]
}, Open  ]],
Cell[58021, 1608, 679, 12, 193, "Text",ExpressionUUID->"be99cbef-5902-4330-ac78-47cba1e2a917"],
Cell[CellGroupData[{
Cell[58725, 1624, 2325, 73, 994, "Input",ExpressionUUID->"60cfb192-7b74-4b3c-8097-331f624d384a"],
Cell[61053, 1699, 720, 24, 83, "Output",ExpressionUUID->"a70c18d2-cdc4-40eb-a413-e5f24b288996"],
Cell[61776, 1725, 200, 4, 83, "Output",ExpressionUUID->"0d69e477-53e3-46e4-a6de-5c33f49f3b0e"]
}, Open  ]],
Cell[61991, 1732, 654, 12, 193, "Text",ExpressionUUID->"961fe8ae-302f-489a-b2f3-20d0a5389a27"],
Cell[CellGroupData[{
Cell[62670, 1748, 1148, 35, 516, "Input",ExpressionUUID->"dc1b2f8d-f6b9-4ba9-9f6c-950e81bc99a9"],
Cell[63821, 1785, 387, 10, 65, "Message",ExpressionUUID->"279aa1ae-a077-4a4a-a9e7-e4ec2414c01f"],
Cell[64211, 1797, 702, 20, 88, "Output",ExpressionUUID->"c0bf39a4-a16c-4339-b317-e7bd769889e2"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64962, 1823, 514, 8, 165, "Section",ExpressionUUID->"876683c2-c208-4de9-84f9-05c9130dc515"],
Cell[65479, 1833, 620, 11, 193, "Text",ExpressionUUID->"6ecc77f4-9a17-4bdd-8631-483cbf1d8062"],
Cell[CellGroupData[{
Cell[66124, 1848, 829, 23, 161, "Input",ExpressionUUID->"1a10efc8-c6c3-4bc4-9a61-76c771ceeebd"],
Cell[66956, 1873, 488, 13, 83, "Output",ExpressionUUID->"5472c355-084c-49e4-90b4-9de0f23d3f8c"],
Cell[67447, 1888, 416, 10, 83, "Output",ExpressionUUID->"6079bada-b040-4f23-909e-1590ddd4164e"]
}, Open  ]],
Cell[67878, 1901, 651, 11, 139, "Text",ExpressionUUID->"85c59dcb-a5c8-4036-9d46-7c5ebb47f9d7"],
Cell[CellGroupData[{
Cell[68554, 1916, 2228, 65, 412, "Input",ExpressionUUID->"5b3cc6fb-1c86-40fa-b781-e53b81f8e1a5"],
Cell[70785, 1983, 1776, 54, 338, "Output",ExpressionUUID->"ede97877-c47a-44d2-9a87-43a3c2eae974"],
Cell[72564, 2039, 202, 4, 83, "Output",ExpressionUUID->"7f10a521-2bd3-4e0a-b178-4fa32fb120be"]
}, Open  ]],
Cell[72781, 2046, 658, 12, 193, "Text",ExpressionUUID->"2d7c1ca4-6719-4217-9e1d-88f114e5d288"],
Cell[73442, 2060, 175, 4, 73, "Input",ExpressionUUID->"da951164-1dc5-487e-a1d5-9736722946b5"],
Cell[CellGroupData[{
Cell[73642, 2068, 974, 31, 226, "Input",ExpressionUUID->"cdf428cf-0fcd-4845-a9cf-28d5fd7073db"],
Cell[74619, 2101, 326, 9, 83, "Output",ExpressionUUID->"cc8b2a58-9e07-4886-8a50-1d41b5376c64"]
}, Open  ]],
Cell[74960, 2113, 660, 12, 139, "Text",ExpressionUUID->"9377e73d-80c7-4fa5-8546-808545dbe3b6"],
Cell[CellGroupData[{
Cell[75645, 2129, 749, 20, 282, "Input",ExpressionUUID->"81e5e26a-400e-4283-a7fe-2bce448629f6"],
Cell[76397, 2151, 226, 5, 83, "Output",ExpressionUUID->"7e1dc9d5-1440-43c6-8f79-ce18f32bea9a"],
Cell[76626, 2158, 360, 10, 83, "Output",ExpressionUUID->"6396e16f-4809-4ab7-9dfc-76a4a9f33869"]
}, Open  ]],
Cell[77001, 2171, 605, 11, 139, "Text",ExpressionUUID->"aa9cadd1-cbf3-46a1-87a2-252df067120d"],
Cell[CellGroupData[{
Cell[77631, 2186, 1364, 42, 347, "Input",ExpressionUUID->"c3740c5c-adc4-42b2-b815-254c6d35ae9e"],
Cell[78998, 2230, 595, 15, 83, "Output",ExpressionUUID->"b61807ab-970b-4707-b4b4-09798c27b0a1"],
Cell[79596, 2247, 254, 5, 83, "Output",ExpressionUUID->"3536698f-cc2e-42f9-a523-b1af251b7a34"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79899, 2258, 556, 8, 165, "Section",ExpressionUUID->"16c08065-5726-4273-b083-93f91b74b8e1"],
Cell[80458, 2268, 583, 10, 139, "Text",ExpressionUUID->"b7f30c82-de20-4e26-95fb-4a65d1d47020"],
Cell[CellGroupData[{
Cell[81066, 2282, 564, 16, 124, "Input",ExpressionUUID->"8ea1014d-bacf-4392-9126-11b9a35ca005"],
Cell[81633, 2300, 280, 8, 83, "Output",ExpressionUUID->"78d8288e-b32c-44dc-8b6c-b77e52d95154"]
}, Open  ]],
Cell[81928, 2311, 614, 11, 139, "Text",ExpressionUUID->"9e079cd2-0fbc-47fd-b89d-e7b0c01e123b"],
Cell[CellGroupData[{
Cell[82567, 2326, 587, 17, 124, "Input",ExpressionUUID->"3a8e8198-cf9c-49d9-a547-fcb2d090bd99"],
Cell[83157, 2345, 326, 10, 104, "Output",ExpressionUUID->"730fa944-2500-4e95-88c8-26462f8574e5"]
}, Open  ]],
Cell[83498, 2358, 674, 12, 193, "Text",ExpressionUUID->"b75388b4-3ccc-44eb-bb0f-6f89fd290c22"],
Cell[CellGroupData[{
Cell[84197, 2374, 1382, 45, 347, "Input",ExpressionUUID->"7a64ba66-a989-4527-8d81-9fb72a38b84c"],
Cell[85582, 2421, 520, 13, 83, "Output",ExpressionUUID->"25615dcb-fa2e-4606-a558-6138c12e9089"],
Cell[86105, 2436, 339, 9, 83, "Output",ExpressionUUID->"18cb2fd9-6370-4d9b-b716-3f1862173a9e"]
}, Open  ]],
Cell[86459, 2448, 704, 12, 193, "Text",ExpressionUUID->"2142f96d-7054-4226-b404-710954ba0cfc"],
Cell[CellGroupData[{
Cell[87188, 2464, 671, 19, 124, "Input",ExpressionUUID->"4a95541f-066e-4913-bebf-220697fd3c19"],
Cell[87862, 2485, 300, 9, 83, "Output",ExpressionUUID->"93ae14fb-5202-4fe5-bcbf-ff5446139565"]
}, Open  ]],
Cell[88177, 2497, 666, 12, 193, "Text",ExpressionUUID->"aecb6604-f0cf-4cd2-acb6-91c03d89b0ea"],
Cell[CellGroupData[{
Cell[88868, 2513, 735, 21, 124, "Input",ExpressionUUID->"aff3cbb4-cae1-47d8-a101-624ccbb6c706"],
Cell[89606, 2536, 279, 8, 83, "Output",ExpressionUUID->"bb16f1c2-e3e3-4d56-8c6d-0dda39448dcf"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[89934, 2550, 566, 8, 165, "Section",ExpressionUUID->"8a4ed504-e802-451a-adf8-4f989bde8f46"],
Cell[90503, 2560, 534, 9, 84, "Text",ExpressionUUID->"10ed39f7-4f3a-4517-abb4-e46f077c2eea"],
Cell[CellGroupData[{
Cell[91062, 2573, 811, 22, 352, "Input",ExpressionUUID->"4d7eb1f7-e9a3-42c6-9785-3256457d9d9f"],
Cell[91876, 2597, 434, 12, 83, "Output",ExpressionUUID->"1e46b6b7-5180-4a64-81e5-e03b675323c4"],
Cell[92313, 2611, 219, 5, 83, "Output",ExpressionUUID->"685c1f34-1304-4950-9012-38a17c714289"],
Cell[92535, 2618, 1014, 26, 126, "Print",ExpressionUUID->"b0b47099-795a-42b8-aff3-cff4ab4852e8"]
}, Open  ]],
Cell[93564, 2647, 548, 8, 84, "Text",ExpressionUUID->"972a7b9d-6083-4234-9e77-a82481015f3c"],
Cell[CellGroupData[{
Cell[94137, 2659, 1049, 27, 352, "Input",ExpressionUUID->"28d53646-0d3c-4a9a-9cb4-3b00c9ef9ed8"],
Cell[95189, 2688, 590, 15, 83, "Output",ExpressionUUID->"1c9372a5-6e0a-43be-8113-9ded9fe041ec"],
Cell[95782, 2705, 249, 5, 83, "Output",ExpressionUUID->"1f09a881-9910-4efd-9050-b477a7400c72"],
Cell[96034, 2712, 1112, 28, 227, "Print",ExpressionUUID->"01ca1724-2cf4-4f57-9cc8-e8387a60a1cf"]
}, Open  ]],
Cell[97161, 2743, 597, 10, 139, "Text",ExpressionUUID->"a0435d51-1eb5-414f-8f79-53e093d378df"],
Cell[CellGroupData[{
Cell[97783, 2757, 1751, 52, 567, "Input",ExpressionUUID->"f26b940d-3720-454d-9f88-2cf0347fd68c"],
Cell[99537, 2811, 592, 14, 83, "Output",ExpressionUUID->"c88e083e-9b85-4916-a9f0-59c33d443b40"],
Cell[100132, 2827, 253, 4, 83, "Output",ExpressionUUID->"efced2b9-58fc-4f96-9398-45f96696367b"],
Cell[100388, 2833, 936, 30, 134, "Output",ExpressionUUID->"f21e2de5-9d82-4279-8d87-c21ad43b7510"],
Cell[101327, 2865, 1114, 28, 227, "Print",ExpressionUUID->"959b9e41-7e40-4b0c-8351-1e60387ae5ce"]
}, Open  ]],
Cell[102456, 2896, 635, 11, 139, "Text",ExpressionUUID->"3ddf9290-2343-48b5-9c9a-47b152427a4b"],
Cell[CellGroupData[{
Cell[103116, 2911, 892, 25, 352, "Input",ExpressionUUID->"cab4b624-ab5c-4468-9504-04c3ca793694"],
Cell[104011, 2938, 480, 14, 83, "Output",ExpressionUUID->"691c6906-6a12-4178-bb1f-47d7a89fa5eb"],
Cell[104494, 2954, 252, 5, 83, "Output",ExpressionUUID->"2fdbce58-5c77-43ac-9513-34cfd2a3e7bc"],
Cell[104749, 2961, 1069, 27, 138, "Print",ExpressionUUID->"bd3b47aa-f919-46d1-a045-e5381595e4c6"]
}, Open  ]],
Cell[105833, 2991, 590, 11, 139, "Text",ExpressionUUID->"cb786ef7-7b6d-4b07-a190-88d9a4dafd51"],
Cell[CellGroupData[{
Cell[106448, 3006, 1216, 36, 352, "Input",ExpressionUUID->"728b7608-a1aa-4d9a-9e1e-2ec317f2f9bb"],
Cell[107667, 3044, 472, 11, 88, "Output",ExpressionUUID->"0228ae0c-1932-43a0-be48-d8b2878b3f5a"],
Cell[108142, 3057, 323, 5, 83, "Output",ExpressionUUID->"86398f85-8d54-47cf-ad34-fdf1e5f44992"],
Cell[108468, 3064, 1163, 28, 182, "Print",ExpressionUUID->"a7f2e62f-ab6a-4573-85a9-e09743d2c541"]
}, Open  ]]
}, Open  ]]
}
]
*)

